///Caption:To Design a Digital IIR Butterworth LPF Filter from Analog IIR 
//Butterworth Filter and LPF to BPF using Digital Transformation
clear all;
clc;
close;
omegaP = 0.2*%pi; //Filter cutoff frequency
omegaL =  (1/5)*%pi;  //Lower Cutoff frequency for BSF                
omegaU =  (3/5)*%pi;  //Upper Cutoff frequency for BSF       
z=poly(0,'z');
H_LPF = (0.245)*(1+(z^-1))/(1-0.509*(z^-1)); //Bilinear transformation
alpha = (cos((omegaU+omegaL)/2)/cos((omegaU-omegaL)/2));//parameter 'alpha'
//parameter 'k'
k = (cos((omegaU - omegaL)/2)/sin((omegaU - omegaL)/2))*tan(omegaP/2);
NUM =-((z^2)-((2*alpha*k/(k+1))*z)+((k-1)/(k+1)));
DEN = (1-((2*alpha*k/(k+1))*z)+(((k-1)/(k+1))*(z^2)));
HZ_BPF=horner(H_LPF,NUM/DEN);//LPF to BPF conversion using digital transformation
disp(HZ_BPF,'Digital BPF IIR Filter H(Z)= ');
HW  =frmag(HZ_BPF(2),HZ_BPF(3),512);//frequency  response
W = 0:%pi/511:%pi;
a=gca();
a.thickness = 1;
plot(W/%pi,HW,'r')
a.foreground = 1;
a.font_style = 9; 
xgrid(1)
xtitle('Magnitude Response of BPF Filter cutoff frequency [0.2,0.6]','Normalized Digital Frequency--->','Magnitude');